package com.ho.crypto.test3.encryption.aes;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

/**
 * Class Test of EncryptionAesEcbPkcs5Padding
 * @author Huseyin OZVEREN
 */
public class EncryptionAesEcbPkcs5PaddingTest {

	public static void main(String[] args) {
		try{
			byte[] keyValue = EncryptionAesEcbPkcs5Padding.generateSecretKey(EncryptionAesEcbPkcs5Padding.INTERNAL_KEY_GENERATION_MODE.GENERATED_WRAPPED_KEY);
	        aEncryptFile(keyValue);
	        bDecryptFile(keyValue);
		}catch(Throwable th){
			th.printStackTrace();
		}
    }

	/**
	 * Encrypt PDF file
	 * @param keyValue : secret key
	 * @throws Exception
	 */
    public static void aEncryptFile(byte[] keyValue) throws Exception {
        try {
            File sourceFile = new File(System.getProperty("user.dir") + "/resources/pdf_with_text.pdf");
            byte[] content = Files.readAllBytes(sourceFile.toPath());
            byte[] encryptContent = EncryptionAesEcbPkcs5Padding.encrypt(keyValue, content);
            File targetFile = new File(System.getProperty("user.dir") + "/resources/pdf_with_text_encrypted_aes_ecb.pdf");
            if(targetFile.exists()){
            	targetFile.delete();
            }
            Files.write(targetFile.toPath(), encryptContent, StandardOpenOption.CREATE_NEW);
        } catch (Exception e) {
        	e.printStackTrace();
        }
    }

    
    /**
	 * Decrypt PDF file
	 * @param keyValue : secret key
     * @throws Exception
     */
    public static void bDecryptFile(byte[] keyValue) throws Exception {
        try {
            byte[] encryptContent = Files.readAllBytes(new File(System.getProperty("user.dir") + "/resources/pdf_with_text_encrypted_aes_ecb.pdf").toPath());
            byte[] decryptContent = EncryptionAesEcbPkcs5Padding.decrypt(keyValue, encryptContent);
            File targetFile = new File(System.getProperty("user.dir") + "/resources/pdf_with_text_decrypted_aes_ecb.pdf");
            if(targetFile.exists()){
            	targetFile.delete();
            }
            Files.write(targetFile.toPath(), decryptContent, StandardOpenOption.CREATE_NEW);
        } catch (Exception e) {
        	e.printStackTrace();
        }

    }
}
